/*
 * Decompiled with CFR 0.152.
 */
package com.github.canbabel.canio.ui;

import com.github.canbabel.canio.dbc.DbcReader;
import com.github.canbabel.canio.kcd.NetworkDefinition;
import com.github.canbabel.canio.ui.FileList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.zip.GZIPInputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = -6772467633506915053L;
    private JFileChooser fc;
    private FileList list = new FileList();
    private Thread convertThread;
    public Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private FileFilter dbcFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".dbc");
        }
    };
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    OutputStream logOutput = new OutputStream(){
        private StringBuilder string = new StringBuilder();

        @Override
        public void write(int b) throws IOException {
            this.string.append((char)b);
        }

        public String toString() {
            return this.string.toString();
        }

        @Override
        public void flush() throws IOException {
            MainFrame.this.jTextArea1.setText(this.string.toString());
        }
    };
    PrintWriter logWriter = new PrintWriter(this.logOutput);
    private Runnable convertRunnable = new Runnable(){

        @Override
        public void run() {
            MainFrame.this.jButton1.setEnabled(false);
            MainFrame.this.jButton2.setEnabled(false);
            MainFrame.this.jButton3.setText("Abort");
            MainFrame.this.jProgressBar1.setEnabled(true);
            MainFrame.this.jProgressBar1.setMinimum(0);
            MainFrame.this.jProgressBar1.setMaximum(MainFrame.this.list.getSize());
            MainFrame.this.jProgressBar1.setValue(0);
            MainFrame.this.jCheckBox1.setEnabled(false);
            MainFrame.this.jCheckBox2.setEnabled(false);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            InputStream resourceAsStream = NetworkDefinition.class.getResourceAsStream("Definition.xsd");
            Validator val = null;
            if (resourceAsStream != null) {
                StreamSource s = new StreamSource(resourceAsStream);
                try {
                    Schema schema = schemaFactory.newSchema(s);
                    val = schema.newValidator();
                }
                catch (SAXException ex) {
                    ex.printStackTrace(MainFrame.this.logWriter);
                }
                ErrorHandler handler = new ErrorHandler(){

                    @Override
                    public void warning(SAXParseException exception) throws SAXException {
                        exception.printStackTrace(MainFrame.this.logWriter);
                    }

                    @Override
                    public void error(SAXParseException exception) throws SAXException {
                        exception.printStackTrace(MainFrame.this.logWriter);
                    }

                    @Override
                    public void fatalError(SAXParseException exception) throws SAXException {
                        exception.printStackTrace(MainFrame.this.logWriter);
                    }
                };
                try {
                    val.setErrorHandler(handler);
                }
                catch (Exception e) {
                    e.printStackTrace(MainFrame.this.logWriter);
                }
            } else {
                MainFrame.this.logWriter.print("Network definition schema can't be found in jar. Started from commandline?\n");
            }
            for (File f : MainFrame.this.list.getFiles()) {
                String filename = f.getPath();
                filename = MainFrame.this.jCheckBox1.isSelected() ? filename.substring(0, filename.length() - 4) + ".kcd.gz" : filename.substring(0, filename.length() - 4) + ".kcd";
                File newFile = new File(filename);
                if (newFile.exists() && !MainFrame.this.jCheckBox3.isSelected()) {
                    int answer = JOptionPane.showConfirmDialog(MainFrame.this.jButton1, "File " + filename + " already exists. Overwrite?");
                    if (answer == 1) {
                        MainFrame.this.jProgressBar1.setValue(MainFrame.this.jProgressBar1.getValue() + 1);
                        continue;
                    }
                    if (answer == 2) {
                        MainFrame.this.jProgressBar1.setValue(0);
                        MainFrame.this.jProgressBar1.setString("");
                        return;
                    }
                }
                if (Thread.interrupted()) break;
                MainFrame.this.jProgressBar1.setString("Converting " + (MainFrame.this.jProgressBar1.getValue() + 1) + " of " + MainFrame.this.jProgressBar1.getMaximum() + ": " + f.getName());
                MainFrame.this.logWriter.write("### Converting " + f.getName() + " ###\n");
                MainFrame.this.logWriter.flush();
                try {
                    DbcReader reader = new DbcReader();
                    if (reader.parseFile(f, MainFrame.this.logOutput)) {
                        reader.writeKcdFile(newFile, MainFrame.this.jCheckBox2.isSelected(), MainFrame.this.jCheckBox1.isSelected());
                        StreamSource source = MainFrame.this.jCheckBox1.isSelected() ? new StreamSource(new GZIPInputStream(new FileInputStream(newFile))) : new StreamSource(newFile);
                        if (val != null) {
                            val.validate(source);
                        }
                    }
                    if (Thread.interrupted()) {
                        break;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(MainFrame.this.logWriter);
                }
                MainFrame.this.logWriter.flush();
                MainFrame.this.jProgressBar1.setValue(MainFrame.this.jProgressBar1.getValue() + 1);
            }
            MainFrame.this.list.clear();
            MainFrame.this.jButton1.setEnabled(true);
            MainFrame.this.jButton2.setEnabled(true);
            MainFrame.this.jButton3.setText("Convert");
            MainFrame.this.jProgressBar1.setValue(0);
            MainFrame.this.jProgressBar1.setString("");
            MainFrame.this.jProgressBar1.setEnabled(false);
            MainFrame.this.jCheckBox1.setEnabled(true);
            MainFrame.this.jCheckBox2.setEnabled(true);
        }
    };

    public MainFrame() {
        this.initComponents();
        this.fc = new JFileChooser(this.prefs.get("user.dir", "."));
        this.fc.setFileFilter(new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.getName().endsWith(".dbc")) {
                    return true;
                }
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return ".dbc files and directories";
            }
        });
        this.fc.setFileSelectionMode(2);
        this.fc.setMultiSelectionEnabled(true);
    }

    private List<File> filesForDirectory(File directory) {
        File[] dirs;
        ArrayList<File> files = new ArrayList<File>();
        File[] dbcFiles = directory.listFiles(this.dbcFilter);
        files.addAll(Arrays.asList(dbcFiles));
        for (File dir : dirs = directory.listFiles(this.directoryFilter)) {
            files.addAll(this.filesForDirectory(dir));
        }
        return files;
    }

    private void initComponents() {
        this.jButton3 = new JButton();
        this.jPanel2 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton2 = new JButton();
        this.jProgressBar1 = new JProgressBar();
        this.jButton4 = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("CANBabel");
        this.setMinimumSize(new Dimension(640, 480));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jButton3.setText("Convert");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton3ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 16;
        this.getContentPane().add((Component)this.jButton3, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jCheckBox1.setText("Gzipped Output");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.2;
        this.jPanel2.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jCheckBox2.setSelected(true);
        this.jCheckBox2.setText("Pretty print XML");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 0.2;
        this.jPanel2.add((Component)this.jCheckBox2, gridBagConstraints);
        this.jCheckBox3.setText("Overwrite all");
        this.jPanel2.add((Component)this.jCheckBox3, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 19;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Information"));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.jPanel3.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Input"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButton1.setText("Add files or folders");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jList1.setModel(this.list);
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButton2.setText("Remove");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jProgressBar1.setEnabled(false);
        this.jProgressBar1.setMinimumSize(new Dimension(410, 23));
        this.jProgressBar1.setPreferredSize(new Dimension(190, 23));
        this.jProgressBar1.setRequestFocusEnabled(false);
        this.jProgressBar1.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        this.getContentPane().add((Component)this.jProgressBar1, gridBagConstraints);
        this.jButton4.setText("Close");
        this.jButton4.setToolTipText("Close application");
        this.jButton4.setAlignmentX(0.5f);
        this.jButton4.setFocusTraversalPolicyProvider(true);
        this.jButton4.setMaximumSize(new Dimension(68, 30));
        this.jButton4.setMinimumSize(new Dimension(68, 30));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.closeButtonHandler(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 14;
        this.getContentPane().add((Component)this.jButton4, gridBagConstraints);
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int returnVal = this.fc.showOpenDialog(this);
        String path = this.fc.getCurrentDirectory().getAbsolutePath();
        System.out.println(path);
        this.prefs.put("user.dir", path);
        if (returnVal == 0) {
            File[] files;
            for (File f : files = this.fc.getSelectedFiles()) {
                if (f.isDirectory()) {
                    List<File> dirFiles = this.filesForDirectory(f);
                    for (File fi : dirFiles) {
                        this.list.addFile(fi);
                    }
                    continue;
                }
                this.list.addFile(f);
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int[] selection = this.jList1.getSelectedIndices();
        Arrays.sort(selection);
        for (int i = 0; i < selection.length; ++i) {
            this.list.remove(selection[i] - i);
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        if (this.convertThread != null && this.convertThread.isAlive()) {
            this.convertThread.interrupt();
            try {
                this.convertThread.join();
            }
            catch (InterruptedException interruptedException) {}
        } else if (this.list.getSize() > 0) {
            this.convertThread = new Thread(this.convertRunnable);
            this.convertThread.start();
        }
    }

    private void closeButtonHandler(ActionEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }
}

